package kom.itbeankit.nw.ethernet;

import kom.itbeankit.nw.ethernet.*;
import kom.itbeankit.common.message.MessageEvent;

public class NonPersistentAlgorithm extends kom.itbeankit.nw.ethernet.OnePersistentAlgorithm
{
    public void onCarrierSense()
    {
        host.carrierSense = SIGNAL_STATUS_ON;
        host.collisionDetect = SIGNAL_STATUS_OFF;
        host.sendDataEvent = null;
        //sense carrier if any event is received
        if(dataEvent!=null){
          host.carrierSense = SIGNAL_STATUS_ALARM;
            //is a new frame received?
            if(isNewFrameReceived()){
                msg(MessageEvent.MSG_TYPE_WARNING,
                    HostTexts.ABORT_CARRIER_SENSE + " host" +dataEvent.getSourceHost()+".");
                beginReceiving();
                return;
            }
            //no new frame,bus is busy, do countdown
            else{
                //wait a random time
                host.countdownTime = getRandomTime();
                msg(MessageEvent.MSG_TYPE_WARNING,
                    HostTexts.BUSY_COUNTDOWN+ ".");
                host.onStatus(HOST_STATUS_COUNTDOWN);           
                return;
            }
        }
        //no events received
        else{
            if(isDataToSend()){
                //create a new data event to send                
                int dSize=host.frameSize;
                if(dSize==FRAME_SIZE_SHORT && host.usePadField)
                    dSize=FRAME_SIZE_NORMAL;
                host.sendDataEvent = new DataEvent(  host,
                                    DATA_TYPE_DATA,
                                    dSize,
                                    host.ID,
                                    host.destinationHost,
                                    true,
                                    false);
                //size of "DATA" to send
                host.remainingSendDataSize = host.frameSize-1;
                host.sentDataSize++;
                host.carrierSense = SIGNAL_STATUS_OFF;
                host.collisionDetect = SIGNAL_STATUS_ON;
                
                //message begin to send
                msg(MessageEvent.MSG_TYPE_INFO,
                    HostTexts.BEGIN_SEND + " " + 
                    getDestinationString(host.destinationHost) + ".");
                //beginto send
                host.onStatus(HOST_STATUS_SENDING_DATA);
                return;
            }
            //no data to send??? go idle
            //should not happen normally
            else{
                msg(MessageEvent.MSG_TYPE_WARNING,
                    HostTexts.GO_IDLE + ".");
                host.onStatus(HOST_STATUS_IDLE);
                return;
            }
        }
    }
}